Attribute VB_Name = "mdCreateHole"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function CreateHole(sk As Object, faces As Object, direction As Integer, htype As Long, extent As Long, holediam As Double, holedpth As Double, tapratio As Double, countdiam As Double, countdpth As Double, countang As Double, drillang As Double, holeName As String)

'Convenience Function to create holes at the center of the circles in the specified sketch

'Get the ProDESKTOP Application Object
GetApplicationObject

'Get the Active Part Document
Dim Part As PartDocument
Set Part = app.GetActiveDoc

'Continue only if Part is available
If Part Is Nothing Then
   Set CreateHole = Nothing
   Exit Function
End If

'Get the active workplane
Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

'Set the value of reversed
Dim plane As zPlane
Set plane = wp.GetGeometry

Dim localX As zDirection
Dim localY As zDirection
Dim planeNormal As zDirection

Set localX = wp.GetLocalX
Set localY = wp.GetLocalY
Set planeNormal = plane.GetNormal

Dim temp As zVector
Set temp = localX.Cross(localY)

Dim result As Double
result = temp.Dot(planeNormal)

Dim reversed As Boolean
If result < 0 Then
    reversed = True
Else
    reversed = False
End If

'Set the value of below
Dim below As Boolean
below = False

If direction = 0 Then
    below = reversed
End If

If direction = 1 Then
    below = Not reversed
End If

Dim hole As aHole
'perform operation to create hole
Set hole = app.GetClass("Hole").CreateHole(Part.GetDesign, sk, faces, direction, htype, extent, holediam, holedpth, tapratio, countdiam, countdpth, countang, drillang, False)
hole.SetName holeName
Part.UpdateDesign

Set CreateHole = hole

End Function

